<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>CouponCodeSale - Best Coupon Deals</title>
  <?php include("inc/links.php") ?>
  <style>
    :root {
      --primary-color: #ff5722;
      --light-bg: #F5F5F5;
      --text-dark: #222;
      --accent-gradient: linear-gradient(135deg, #f4f7fa, #f4f7fa);
    }

    body {
      background-color: var(--light-bg);
      font-family: "Poppins", sans-serif;
    }

    /* Top announcement bar */
    .top-bar {
      background: var(--accent-gradient);
      color: #000;
      text-align: center;
      padding: 6px;
      font-size: 14px;
    }

    /* Navbar */
    .navbar {
      background: #fff;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }

    .navbar-brand img {
      height: 55px;
    }

    .nav-link {
      color: #333 !important;
      font-weight: 500;
      margin: 0 6px;
      transition: 0.3s;
    }

    .nav-link:hover {
      color: var(--primary-color) !important;
    }

    /* Hero Section */
    .hero {
      background: var(--accent-gradient);
      padding: 80px 0;
      text-align: center;
      color: #000;
    }

    .hero h1 {
      font-weight: 700;
      font-size: 5.5vw;
      text-align: left;
    }

    .hero input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px 20px;
    }

    .hero button {
      border-radius: 0 5px 5px 0;
      background: #000;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Coupons Section */
    .coupon-card {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 3px 12px rgba(0, 0, 0, 0.06);
      padding: 25px;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .coupon-card:hover {
      transform: translateY(-6px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }

    .coupon-badge {
      background: var(--primary-color);
      color: #000;
      font-weight: 600;
      border-radius: 50px;
      padding: 6px 15px;
      display: inline-block;
      font-size: 0.9rem;
    }

    .coupon-btn {
      background: var(--accent-gradient);
      border: none;
      color: #000;
      font-weight: 600;
      border-radius: 8px;
      padding: 10px 20px;
      transition: 0.3s;
    }

    .coupon-btn:hover {
      background: #000;
      color: #fff;
    }

    /* Categories Section */
    .category-card {
      background: #fff;
      border-radius: 16px;
      text-align: center;
      padding: 25px;
      transition: 0.3s;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .category-card:hover {
      background: var(--primary-color);
      color: #000;
      transform: translateY(-5px);
    }

    /* Newsletter */
    .newsletter {
      background: var(--accent-gradient);
      padding: 50px 0;
      text-align: center;
    }

    .newsletter input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px;
      width: 60%;
      max-width: 400px;
    }

    .newsletter button {
      border-radius: 0 5px 5px 0;
      background: #000;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Footer */
    footer {
      background: #111;
      color: #ccc;
      padding: 60px 0 20px;
    }

    footer h5 {
      color: var(--primary-color);
      margin-bottom: 20px;
    }

    footer a {
      color: #ccc;
      text-decoration: none;
      display: block;
      margin-bottom: 8px;
      transition: 0.3s;
    }

    footer a:hover {
      color: #fff;
    }

    .coupon-card h5 {
      white-space: nowrap;
      /* Force text to stay in a single line */
      overflow: hidden;
      /* Hide overflow text */
      text-overflow: ellipsis;
      /* Add "..." at the end */
      display: block;
    }

    .coupon-card p {
      min-height: 50px;
      display: -webkit-box;
      -webkit-line-clamp: 2;
      /* limit to 2 lines */
      -webkit-box-orient: vertical;
      overflow: hidden;
    }
  </style>
  <style>
    body {
      scroll-behavior: smooth;
    }

    .alphabet-nav {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      gap: 8px;
      margin-bottom: 30px;
    }

    .alphabet-nav a {
      display: inline-block;
      color: #000;
      background-color: #f5f5f5;
      border: 1px solid #ddd;
      border-radius: 50%;
      width: 35px;
      height: 35px;
      text-align: center;
      line-height: 33px;
      font-weight: 600;
      transition: all 0.3s ease;
      text-decoration: none;
    }

    .alphabet-nav a:hover {
      background-color: #ff5722;
      color: #fff!important;
      border-color: #ff5722;
    }

    .alphabet-section {
      margin-top: 50px;
    }

    .alphabet-header {
      font-size: 28px;
      font-weight: bold;
      border-bottom: 2px solid #eee;
      margin-bottom: 25px;
      padding-bottom: 5px;
    }

    .store-card {
      text-align: center;
      margin-bottom: 30px;
      transition: transform 0.3s ease;
    }

    .store-card:hover {
      transform: translateY(-5px);
    }

    .store-img {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      border: 3px solid #ff5722;
      object-fit: cover;
      margin-bottom: 10px;
    }

    .store-card a {
      text-decoration: none !important;
    }
  </style>
</head>

<body>
  <!-- Announcement -->
  <?php include("inc/topbar.php"); ?>
  <!-- Navbar -->
  <?php include("inc/header.php"); ?>
  <?php
  // Fetch all stores ordered alphabetically
  $query = "SELECT * FROM store ORDER BY sname ASC";
  $result = mysqli_query($conn, $query);

  // Group stores by their first letter
  $stores_by_letter = [];

  while ($row = mysqli_fetch_assoc($result)) {
    $first_letter = strtoupper(substr($row['sname'], 0, 1));
    if (!ctype_alpha($first_letter)) {
      $first_letter = '#'; // For names not starting with A–Z
    }
    $stores_by_letter[$first_letter][] = $row;
  }

  ksort($stores_by_letter);
  ?>

  <div class="container py-5">

    <h2 class="text-center fw-bold mb-4">All Stores A–Z</h2>

    <!--  Alphabet Navigation -->
    <div class="alphabet-nav text-center mb-4">
      <?php foreach (range('A', 'Z') as $letter): ?>
        <a href="#letter-<?php echo $letter; ?>" class="mx-1 text-dark fw-semibold">
          <?php echo $letter; ?>
        </a>
      <?php endforeach; ?>
    </div>

    <!-- 🔡 Dynamic Alphabet Sections -->
    <?php foreach ($stores_by_letter as $letter => $stores): ?>
      <div class="alphabet-section mb-5" id="letter-<?php echo $letter; ?>">
        <div class="alphabet-header"><?php echo $letter; ?></div>
        <div class="row">
          <?php foreach ($stores as $store): ?>
            <div class="col-6 col-sm-4 col-md-3 col-lg-2 store-card text-center mb-4">
              <a href="store/<?php echo $store['url']; ?>" class="text-decoration-none text-dark">
                <img
                  src="./admin/img/new/stores/<?php echo htmlspecialchars($store['img']); ?>"
                  alt="<?php echo htmlspecialchars($store['sname']); ?>"
                  class="store-img rounded-circle border"
                  style="width:100px;height:100px;object-fit:contain;background:#fff;">
                <div class="fw-semibold mt-2"><?php echo html_entity_decode($store['sname']); ?></div>
              </a>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    <?php endforeach; ?>

  </div>
  <!-- Footer -->

  <?php include("inc/footer.php"); ?>

  <?php include("inc/modals.php"); ?>
  <?php include("inc/footer_lnks.php"); ?>

</body>

</html>