<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>CouponCodeSale - Best Coupon Deals</title>
  <?php include("inc/links.php") ?>
  <style>
    :root {
      --primary-color: #FF5722;
      --light-bg: #F5F5F5;
      --text-dark: #222;
      --accent-gradient: linear-gradient(135deg, #f4f7fa, #f4f7fa);
    }

    body {
      background-color: var(--light-bg);
      font-family: "Poppins", sans-serif;
    }

    /* Top announcement bar */
    .top-bar {
      background: var(--accent-gradient);
      color: #000;
      text-align: center;
      padding: 6px;
      font-size: 14px;
    }

    /* Navbar */
    .navbar {
      background: #fff;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }

    .navbar-brand img {
      height: 55px;
    }

    .nav-link {
      color: #333 !important;
      font-weight: 500;
      margin: 0 6px;
      transition: 0.3s;
    }

    .nav-link:hover {
      color: var(--primary-color) !important;
    }

    /* Hero Section */
    .hero {
      background: var(--accent-gradient);
      padding: 80px 0;
      text-align: center;
      color: #000;
    }

    .hero h1 {
      font-weight: 700;
      font-size: 5.5vw;
      text-align: left;
    }

    .hero input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px 20px;
    }

    .hero button {
      border-radius: 0 5px 5px 0;
      background: #003366;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Coupons Section */
    .coupon-card {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 3px 12px rgba(0, 0, 0, 0.06);
      padding: 25px;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .coupon-card:hover {
      transform: translateY(-6px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }

    .coupon-badge {
      background: var(--primary-color);
      color: #fff;
      font-weight: 600;
      border-radius: 50px;
      padding: 6px 15px;
      display: inline-block;
      font-size: 0.9rem;
    }

    .coupon-btn {
      background: var(--accent-gradient);
      border: none;
      color: #000;
      font-weight: 600;
      border-radius: 8px;
      padding: 10px 20px;
      transition: 0.3s;
    }

    .coupon-btn:hover {
      background: #000;
      color: #fff;
    }

    /* Categories Section */
    .category-card {
      background: #fff;
      border-radius: 16px;
      text-align: center;
      padding: 25px;
      transition: 0.3s;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .category-card:hover {
      background: var(--primary-color);
      color: #000;
      transform: translateY(-5px);
    }

    /* Newsletter */
    .newsletter {
      background: var(--accent-gradient);
      padding: 50px 0;
      text-align: center;
    }

    .newsletter input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px;
      width: 60%;
      max-width: 400px;
    }

    .newsletter button {
      border-radius: 0 5px 5px 0;
      background: #003366;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Footer */
    footer {
      background: #111;
      color: #ccc;
      padding: 60px 0 20px;
    }

    footer h5 {
      color: var(--primary-color);
      margin-bottom: 20px;
    }

    footer a {
      color: #ccc;
      text-decoration: none;
      display: block;
      margin-bottom: 8px;
      transition: 0.3s;
    }

    footer a:hover {
      color: #fff;
    }

    .coupon-card h5 {
      white-space: nowrap;
      /* Force text to stay in a single line */
      overflow: hidden;
      /* Hide overflow text */
      text-overflow: ellipsis;
      /* Add "..." at the end */
      display: block;
    }

    .coupon-card p {
      min-height: 50px;
      display: -webkit-box;
      -webkit-line-clamp: 2;
      /* limit to 2 lines */
      -webkit-box-orient: vertical;
      overflow: hidden;
    }
  </style>
  <style>
    /* Carousel section */
    .store-carousel {
      padding: 60px 0;
      background: #fff;
      text-align: center;
    }

    .store-carousel h2 {
      font-weight: 700;
      margin-bottom: 40px;
    }

    /* Each store item */
    .store-item {
      text-align: center;
      padding: 10px;
    }

    .store-item a {
      text-decoration: none;
      color: #222;
    }

    .store-item img {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      object-fit: cover;
      margin: 0 auto 10px;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      border: 3px solid #FF5722;
    }

    .store-item:hover img {
      transform: scale(1.05);
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .store-name {
      font-weight: 600;
      font-size: 16px;
      margin-top: 5px;
    }

    /* Slick arrows styling */
    .slick-prev:before,
    .slick-next:before {
      color: #000;
      font-size: 28px;
    }

    /* Responsive tweak for smaller devices */
    @media (max-width: 576px) {
      .store-item img {
        width: 80px;
        height: 80px;
      }

      .store-name {
        font-size: 14px;
      }
    }
  </style>
  <style>
          .search-data{
             background:#fff;position:absolute;width:100%;
             z-index:1119;
         }
         .search-data p{
             color:#333;
             margin:0px;
             padding:10px 30px;
             cursor:pointer;
         }
         .search-data p:hover{
             background:#003366;
             color:#fff;
         }
          .search-data a{
              text-decoration:none;
          }
    </style>
</head>

<body>
  <!-- Announcement -->
    <?php include("inc/topbar.php"); ?>
  <!-- Navbar -->
    <?php include("inc/header.php"); ?>
  <!-- Hero -->
  <section class="hero">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-4">
          <img src="./assets/images/fgdsa.svg">
        </div>
        <div class="col-md-8" style="position:relative">
          <h1>Find Top Deals, Discounts & Coupons</h1>
          <div class="d-flex justify-content-space w-100 w-sm-75">
            <input type="text"  id="search"  class="w-100" placeholder="Search Coupons & Deals..." />
            <button id="sbtn"><i class="fa-solid fa-magnifying-glass"></i></button>
          </div>
              <div style="display:none;position:absolute;" class="bg-white mt-3 search-data  w-100 w-sm-75" id="sdata">
                                 <P class="data" data-name="hello">hello</P>
                              </div>
        </div>
      </div>

    </div>
  </section>

  <!-- Carousel HTML -->
  <section class="store-carousel">
    <div class="container">
      <h2>🏪 Popular Stores</h2>

      <div class="store-slider">
        <?php 
        $SQL="SELECT * FROM store order by rand() limit 10";
        $re=mysqli_query($conn,$SQL);
        while($row=mysqli_fetch_assoc($re)){
          ?>
            <div class="store-item">
              <a  href="store/<?php echo $row['url']; ?>" target="_blank">
                <img src="./admin/img/new/stores/<?php echo $row['img']; ?>" style="padding:5px;object-fit:contain" alt="Nike">
                <div class="store-name"><?php echo $row['sname'] ?></div>
              </a>
            </div>
          <?php
        }
        ?>

   
      </div>
    </div>
  </section>

  <!-- Latest Coupons -->
  <section class="py-5">
    <div class="container">
      <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold">🔥 Latest Coupons</h2>
        <!--<button class="btn btn-dark btn-sm" data-bs-toggle="modal" data-bs-target="#submitCouponModal">Submit Coupon</button>-->
      </div>

      <div class="row g-4">
        <!-- Coupon Card -->
       <?php 


// Fetch 15 coupons with empty c_code (Deals)
$deals_query = "
    SELECT * FROM coupons 
    WHERE (c_code IS NULL OR c_code = '') 
    GROUP BY store_name 
    ORDER BY RAND() 
    LIMIT 15
";
$deals_result = mysqli_query($conn, $deals_query);

// Fetch 15 coupons with non-empty c_code (Codes)
$codes_query = "
    SELECT * FROM coupons 
    WHERE c_code IS NOT NULL AND c_code != '' 
    GROUP BY store_name 
    ORDER BY RAND() 
    LIMIT 15
";
$codes_result = mysqli_query($conn, $codes_query);

// Merge results
$all_coupons = [];
while ($row = mysqli_fetch_assoc($deals_result)) {
    $all_coupons[] = $row;
}
while ($row = mysqli_fetch_assoc($codes_result)) {
    $all_coupons[] = $row;
}

// Shuffle once more for randomness if you like
shuffle($all_coupons);

foreach ($all_coupons as $row) {
?>
    <div class="col-md-4">
        <div class="coupon-card">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <?php 
                if(empty($row['discount_title'])){
                    if(empty($row['c_code'])){
                        echo '<span class="coupon-badge">Deal</span>';
                    } else {
                        echo '<span class="coupon-badge">Code</span>';
                    } 
                } else {
                    echo '<span class="coupon-badge">'.htmlspecialchars($row['discount_title']).'</span>';
                }

                // Store query
                $storeQ = "SELECT * FROM store WHERE sname LIKE '%" . mysqli_real_escape_string($conn, $row['store_name']) . "%' LIMIT 1";
                $storeRes = mysqli_query($conn, $storeQ);
                $store = mysqli_fetch_assoc($storeRes);
                ?>
                <a href="store/<?php echo $store['url']; ?>">
                  <img src="./admin/img/new/stores/<?php echo htmlspecialchars($store['img']); ?>" 
                     style="width:60px;height:60px;object-fit:contain;    border: 1px solid #e4e4e4;" 
                     class="rounded-circle" 
                     alt="<?php echo html_entity_decode(htmlspecialchars($store['sname'])); ?>">
                </a>
            </div>
            <h5 class="fw-bold mb-2"><?php echo str_replace("â€”","-",str_replace("Â£","£",htmlspecialchars_decode($row['name'], ENT_QUOTES | ENT_HTML5))); ?></h5>
            <p><?php echo str_replace("â€”","-",str_replace("Â£","£",htmlspecialchars_decode($row['c_desc'], ENT_QUOTES | ENT_HTML5))); ?></p>
            <?php if(empty($row['c_code'])): ?>
                <button class="coupon-btn show_coupon_btn_"  data-coupon_id='<?php echo $row['id'] ?>' data-store_image="<?php echo $domain; ?>admin/img/new/stores/<?php echo $store['img']; ?>"  data-name="<?php echo $row['name'] ?>"  rel="nofollow"  data-name="<?php echo $row['name'] ?>" data-sname="<?php echo $row['store_name'] ?>" data-terms="<?php echo $row['ex1'] ?>" data-code="<?php echo $row['c_code']; ?>"
                                                        data-tracking="<?php echo $row['track_link'] ?>">Get Deal</button>
            <?php else: ?>
                <button class="coupon-btn show_coupon_btn_"   data-coupon_id='<?php echo $row['id'] ?>' data-store_image="<?php echo $domain; ?>admin/img/new/stores/<?php echo $store['img']; ?>"  data-name="<?php echo $row['name'] ?>"  rel="nofollow"  data-name="<?php echo $row['name'] ?>" data-sname="<?php echo $row['store_name'] ?>" data-terms="<?php echo $row['ex1'] ?>" data-code="<?php echo $row['c_code']; ?>"
                                                        data-tracking="<?php echo $row['track_link'] ?>" >Get Code</button>
            <?php endif; ?>
        </div>
    </div>
<?php
}
?>

       

       
      </div>
    </div>
  </section>

  <!-- Trending Categories -->
  <section class="py-5 bg-white">
    <div class="container">
      <h2 class="fw-bold text-center mb-4">🏷️ Trending Categories</h2>
      <div class="row g-4">
        <?php
        $Q="SELECT * FROM category order by rand() limit 8";
        $re=mysqli_query($conn,$Q);
        while($row=mysqli_fetch_assoc($re)){
          ?>
            <div class="col-6 col-md-3">
              <a href="category/<?php echo $row['url']; ?>" style="color:#333;text-decoration:none;"><div class="category-card"><img src="./admin/img/new/category/<?php echo $row['c_img']; ?>" style="width:40px;height:40px;object-fit:contain;" class="rounded-circle" alt="store logo"><?php echo $row['c_name']; ?></div></a>
            </div>
          <?php
        }
        ?>
     

      </div>
    </div>
  </section>

  <!-- Newsletter -->
  <section class="newsletter">
    <div class="container">
      <h2 class="fw-bold mb-3">Subscribe to Get the Latest Coupons & Offers</h2>
      <div class="d-flex justify-content-center">
        <input type="email"  id="newsletterEmail" placeholder="Enter your email..." />
        <button  id="subscribe_email_section_button" ><i class="fa-solid fa-arrow-right"></i></button>
      </div>
      <p id="success_or_failed_message"></p>
    </div>
  </section>

  <!-- Footer -->

<?php include("inc/footer.php"); ?>

<?php include("inc/modals.php"); ?>
<?php include("inc/footer_lnks.php"); ?>
    <!-- Slick Init Script -->
  <script>
    $(document).ready(function() {
      $('.store-slider').slick({
        slidesToShow: 6,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 1500,
        arrows: true,
        dots: false,
        pauseOnHover: false,
        responsive: [{
            breakpoint: 1200,
            settings: {
              slidesToShow: 5
            }
          },
          {
            breakpoint: 992,
            settings: {
              slidesToShow: 4
            }
          },
          {
            breakpoint: 768,
            settings: {
              slidesToShow: 3
            }
          },
          {
            breakpoint: 576,
            settings: {
              slidesToShow: 2
            }
          }
        ]
      });
    });
  </script>
   <script>
         $(document).ready(function(){
             $('#sdata').hide();
             $('#search').on('keyup',function(e){
                 e.preventDefault();
                 var val=$(this).val();
                 $.ajax({
                    url:"ajax-live-search.php",
                    method:"post",
                    data:{
                        val:val
                    },
                    success:function(data){
                        // console.log(data)
                        $('#sdata').html(data);
                     
                         if(val==''){
                              $('#sdata').hide();
                         }else{
                                 $('#sdata').show();
                         }
                    }
                 });
             });
             $(document).on('click','.data',function(e){
                var val=$(this).data('name');
                $('#search').val(val);
             $('#sdata').hide();
             });
         });
         
      </script>
          <script>
              
                $("#success_or_failed_message").hide() 
                $("#subscribe_email_section_button").on("click", (function(e) {
                 var s = $("#newsletterEmail").val().trim();  // <-- IMPORTANT FIX

// Email Regex
var regex = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,7}$/;

if (s === "" || !regex.test(s)) {
    $("#success_or_failed_message").html("<strong>Invalid email!</strong> Please enter a valid email address");
     $("#success_or_failed_message").css("color","red");
    $("#success_or_failed_message").show();
} 
else {
    $.ajax({
        url: "inc/functions.php",
        method: "post",
        data: {
            val: s,
            type: "email_subscribe"
        },
        success: function(e) {

            if (e == 1) {
                $("#success_or_failed_message").html("Thank you for your subscription!")
                    .css("color", "green")
                    .css("visibility", "visible")
                    .css("text-align", "center")
                    .show();
                $("#footer_email").val("");
            }

            if (e == 0) {
                $("#success_or_failed_message").html("<strong>Oops!</strong> Something went wrong")
                    .css("color", "red")
                    .css("text-align", "center")
                    .show();
            }

            setTimeout(() => {
                $("#success_or_failed_message").hide();
            }, 2000);

        }
    });
}

                  
              
                }))
          </script>
</body>

</html>